7
<?php
session_start();

// Admin credentials
define('ADMIN_USERNAME', 'DEEPAK');
define('ADMIN_PASSWORD', 'DEEPAK');

// Database configuration - SAME AS control.php
define('DB_HOST', 'localhost');
define('DB_USER', 'bbteammo_Deepakhhh');
define('DB_PASS', 'bbteammo_Deepakhhh');
define('DB_NAME', 'bbteammo_Deepakhhh');

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

// Login function
function login($username, $password) {
    if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['login_time'] = time();
        return true;
    }
    return false;
}

// Logout function
function logout() {
    session_destroy();
    header('Location: admin.php');
    exit;
}

// ✅ RESET ALL USERS FUNCTION
function resetAllUsers() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        return false;
    }
    
    try {
        // Delete all users from users table
        $conn->query("DELETE FROM users");
        
        // Reset version statistics
        $conn->query("DELETE FROM version_statistics");
        
        $conn->close();
        return true;
    } catch (Exception $e) {
        $conn->close();
        return false;
    }
}

// ✅ SIMPLE AND RELIABLE STATISTICS FUNCTION
function getStatistics() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        // Return default values if database connection fails
        return [
            'total_users' => 0,
            'active_users' => 0,
            'new_today' => 0,
            'new_week' => 0,
            'total_requests' => 0,
            'version_stats' => [],
            'recent_users' => []
        ];
    }
    
    $stats = [];
    
    try {
        // Total unique users
        $result = $conn->query("SELECT COUNT(DISTINCT user_id) as total FROM users");
        $stats['total_users'] = $result ? ($result->fetch_assoc()['total'] ?? 0) : 0;
        
        // Active users (last 24 hours)
        $timeThreshold = date('Y-m-d H:i:s', strtotime('-24 hours'));
        $result = $conn->query("SELECT COUNT(DISTINCT user_id) as active FROM users WHERE last_seen > '$timeThreshold'");
        $stats['active_users'] = $result ? ($result->fetch_assoc()['active'] ?? 0) : 0;
        
        // Today's new users
        $todayStart = date('Y-m-d 00:00:00');
        $result = $conn->query("SELECT COUNT(DISTINCT user_id) as new_today FROM users WHERE first_seen >= '$todayStart'");
        $stats['new_today'] = $result ? ($result->fetch_assoc()['new_today'] ?? 0) : 0;
        
        // This week's new users
        $weekStart = date('Y-m-d 00:00:00', strtotime('-7 days'));
        $result = $conn->query("SELECT COUNT(DISTINCT user_id) as new_week FROM users WHERE first_seen >= '$weekStart'");
        $stats['new_week'] = $result ? ($result->fetch_assoc()['new_week'] ?? 0) : 0;
        
        // Total requests
        $result = $conn->query("SELECT SUM(request_count) as total_requests FROM users");
        $stats['total_requests'] = $result ? ($result->fetch_assoc()['total_requests'] ?? 0) : 0;
        
        // Version statistics - SIMPLE QUERY
        $stats['version_stats'] = [];
        $result = $conn->query("SELECT app_version, total_users FROM version_statistics ORDER BY last_updated DESC");
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $stats['version_stats'][] = $row;
            }
        }
        
        // Recent active users
        $stats['recent_users'] = [];
        $result = $conn->query("SELECT user_id, device_id, first_seen, last_seen, request_count, app_version FROM users ORDER BY last_seen DESC LIMIT 10");
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $stats['recent_users'][] = $row;
            }
        }
        
    } catch (Exception $e) {
        // If any error, return empty stats
        $stats = [
            'total_users' => 0,
            'active_users' => 0,
            'new_today' => 0,
            'new_week' => 0,
            'total_requests' => 0,
            'version_stats' => [],
            'recent_users' => []
        ];
    }
    
    $conn->close();
    return $stats;
}

// Update expiry settings WITH VERSION CONTROL
function updateExpirySettings($expiryDate, $customMessage, $telegramUrl, $latestVersion, $updateUrl, $changelog, $forceUpdate) {
    $settings = [
        'expiry_date' => $expiryDate,
        'custom_message' => $customMessage,
        'telegram_url' => $telegramUrl,
        'latest_version' => $latestVersion,
        'update_url' => $updateUrl,
        'changelog' => $changelog,
        'force_update' => $forceUpdate,
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    file_put_contents('app_settings.json', json_encode($settings, JSON_PRETTY_PRINT));
    return true;
}

// Get current settings
function getCurrentSettings() {
    if (file_exists('app_settings.json')) {
        $settings = json_decode(file_get_contents('app_settings.json'), true);
        if ($settings) {
            return $settings;
        }
    }
    
    // Default settings
    return [
        'expiry_date' => date('Y-m-d', strtotime('+30 days')),
        'custom_message' => '✨ NOVA STRIKE MODS\n🚫 Version Expired!\n\n📢 Update to latest version.',
        'telegram_url' => 'https://t.me/novastrikemods',
        'latest_version' => '1.0.0',
        'update_url' => 'https://t.me/novastrikemods',
        'changelog' => '• Initial Release\n• Bug Fixes\n• Performance Improvements',
        'force_update' => 'no',
        'updated_at' => date('Y-m-d H:i:s')
    ];
}

// ✅ SIMPLE TABLE CREATION
function createTablesIfNotExists() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
    
    if ($conn->connect_error) {
        return false;
    }
    
    // Create database if not exists
    $conn->query("CREATE DATABASE IF NOT EXISTS " . DB_NAME);
    $conn->select_db(DB_NAME);
    
    // Main users table
    $sql_users = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id VARCHAR(255) NOT NULL,
        device_id VARCHAR(255) NOT NULL,
        first_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        last_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        ip_address VARCHAR(45),
        user_agent TEXT,
        request_count INT DEFAULT 1,
        app_version VARCHAR(50),
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_user_id (user_id),
        INDEX idx_device_id (device_id),
        INDEX idx_last_seen (last_seen),
        INDEX idx_app_version (app_version)
    )";
    
    // Version-wise statistics table
    $sql_version_stats = "CREATE TABLE IF NOT EXISTS version_statistics (
        id INT AUTO_INCREMENT PRIMARY KEY,
        app_version VARCHAR(50) NOT NULL,
        total_users INT DEFAULT 0,
        active_users INT DEFAULT 0,
        total_requests INT DEFAULT 0,
        first_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        last_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_version (app_version)
    )";
    
    $conn->query($sql_users);
    $conn->query($sql_version_stats);
    $conn->close();
    return true;
}

// Create settings file if not exists
function createSettingsFileIfNotExists() {
    if (!file_exists('app_settings.json')) {
        $defaultSettings = [
            'expiry_date' => date('Y-m-d', strtotime('+30 days')),
            'custom_message' => '✨ NOVA STRIKE MODS\n🚫 Version Expired!\n\n📢 Update to latest version.',
            'telegram_url' => 'https://t.me/novastrikemods',
            'latest_version' => '1.0.0',
            'update_url' => 'https://t.me/novastrikemods',
            'changelog' => '• Initial Release\n• Bug Fixes\n• Performance Improvements',
            'force_update' => 'no',
            'updated_at' => date('Y-m-d H:i:s')
        ];
        file_put_contents('app_settings.json', json_encode($defaultSettings, JSON_PRETTY_PRINT));
    }
}

// ✅ TEST DATABASE CONNECTION
function testDatabaseConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        return "Database Connection FAILED: " . $conn->connect_error;
    }
    
    // Check if tables exist
    $result = $conn->query("SHOW TABLES LIKE 'users'");
    $usersTableExists = $result && $result->num_rows > 0;
    
    $result = $conn->query("SHOW TABLES LIKE 'version_statistics'");
    $versionTableExists = $result && $result->num_rows > 0;
    
    $conn->close();
    
    return "Database Connection SUCCESS | Users Table: " . ($usersTableExists ? "EXISTS" : "MISSING") . " | Version Table: " . ($versionTableExists ? "EXISTS" : "MISSING");
}

// Initialize
createTablesIfNotExists();
createSettingsFileIfNotExists();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['login'])) {
        // Login attempt
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        
        if (login($username, $password)) {
            header('Location: admin.php');
            exit;
        } else {
            $error = "Invalid username or password!";
        }
    }
    elseif (isset($_POST['update_settings']) && isLoggedIn()) {
        // Update settings
        $expiryDate = $_POST['expiry_date'] ?? '';
        $customMessage = $_POST['custom_message'] ?? '';
        $telegramUrl = $_POST['telegram_url'] ?? '';
        $latestVersion = $_POST['latest_version'] ?? '';
        $updateUrl = $_POST['update_url'] ?? '';
        $changelog = $_POST['changelog'] ?? '';
        $forceUpdate = $_POST['force_update'] ?? 'no';
        
        if (updateExpirySettings($expiryDate, $customMessage, $telegramUrl, $latestVersion, $updateUrl, $changelog, $forceUpdate)) {
            $success = "Settings updated successfully!";
        } else {
            $error = "Failed to update settings!";
        }
    }
    elseif (isset($_POST['test_db']) && isLoggedIn()) {
        // Test database connection
        $db_test_result = testDatabaseConnection();
    }
    elseif (isset($_POST['reset_users']) && isLoggedIn()) {
        // Reset all users
        if (resetAllUsers()) {
            $success = "All users data has been reset successfully!";
        } else {
            $error = "Failed to reset users data!";
        }
    }
    elseif (isset($_POST['logout'])) {
        logout();
    }
}

// Check if logout requested
if (isset($_GET['logout'])) {
    logout();
}

// Get data for dashboard
if (isLoggedIn()) {
    $stats = getStatistics();
    $settings = getCurrentSettings();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Control Panel - NOVA STRIKE MODS</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --primary: #8B0000;
            --primary-dark: #660000;
            --secondary: #FF6B00;
            --danger: #DC143C;
            --warning: #FFA500;
            --dark: #1a1a1a;
            --light: #f8f9fa;
            --gray: #6b7280;
            --success: #32CD32;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, var(--dark) 0%, var(--primary) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
            overflow: hidden;
            width: 100%;
            max-width: 1400px;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: rgba(255,255,255,0.1);
            transform: rotate(30deg);
        }
        
        .header-content {
            position: relative;
            z-index: 1;
        }
        
        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 1.1em;
        }
        
        .content {
            padding: 40px;
        }
        
        .login-form {
            max-width: 400px;
            margin: 0 auto;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: var(--light);
            padding: 25px;
            border-radius: 10px;
            text-align: center;
            border-left: 4px solid var(--primary);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .stat-card.total-users { border-left-color: var(--primary); }
        .stat-card.active-users { border-left-color: var(--success); }
        .stat-card.new-today { border-left-color: var(--warning); }
        .stat-card.new-week { border-left-color: var(--secondary); }
        .stat-card.total-requests { border-left-color: var(--danger); }
        
        .stat-card i {
            font-size: 2em;
            margin-bottom: 10px;
            display: block;
        }
        
        .stat-card.total-users i { color: var(--primary); }
        .stat-card.active-users i { color: var(--success); }
        .stat-card.new-today i { color: var(--warning); }
        .stat-card.new-week i { color: var(--secondary); }
        .stat-card.total-requests i { color: var(--danger); }
        
        .stat-card h3 {
            color: var(--dark);
            font-size: 2em;
            margin-bottom: 5px;
        }
        
        .stat-card p {
            color: var(--gray);
            font-weight: 500;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
        }
        
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(139, 0, 0, 0.4);
        }
        
        .btn-logout {
            background: var(--gray);
            color: white;
            padding: 12px 20px;
            font-size: 16px;
        }
        
        .btn-test {
            background: var(--warning);
            color: white;
            padding: 12px 20px;
            font-size: 16px;
        }
        
        .btn-reset {
            background: var(--danger);
            color: white;
            padding: 12px 20px;
            font-size: 16px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-error {
            background: #ffeaea;
            color: var(--danger);
            border-left: 4px solid var(--danger);
        }
        
        .alert-success {
            background: #eaffea;
            color: var(--success);
            border-left: 4px solid var(--success);
        }
        
        .alert-info {
            background: #eaf4ff;
            color: var(--primary);
            border-left: 4px solid var(--primary);
        }
        
        .recent-users, .version-stats {
            background: var(--light);
            padding: 25px;
            border-radius: 10px;
            margin-top: 30px;
        }
        
        .recent-users h3, .version-stats h3 {
            margin-bottom: 20px;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-table, .version-table {
            width: 100%;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 0 0 1px #e5e7eb;
        }
        
        .user-table th, .user-table td,
        .version-table th, .version-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e9ecef;
        }
        
        .user-table th, .version-table th {
            background: var(--primary);
            color: white;
            font-weight: 600;
        }
        
        .user-table tr:hover, .version-table tr:hover {
            background: #f1f2f6;
        }
        
        .settings-form {
            background: var(--light);
            padding: 25px;
            border-radius: 10px;
            margin-top: 30px;
        }
        
        .settings-form h3 {
            margin-bottom: 20px;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .settings-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        .settings-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #e9ecef;
        }
        
        .settings-section h4 {
            margin-bottom: 15px;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 15px;
        }
        
        .checkbox-group input[type="checkbox"] {
            width: 18px;
            height: 18px;
        }
        
        .checkbox-group label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 0;
        }
        
        .header-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .welcome-message {
            font-size: 1.1em;
            color: var(--dark);
        }
        
        .welcome-message span {
            color: var(--primary);
            font-weight: 600;
        }
        
        .login-icon {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .login-icon i {
            font-size: 4em;
            color: var(--primary);
        }
        
        .credential-hint {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
            background: #f0f9ff;
            border-radius: 8px;
            border-left: 4px solid var(--primary);
        }
        
        .info-badge {
            background: var(--primary);
            color: white;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 0.8em;
            font-weight: 600;
        }
        
        .version-badge {
            background: var(--success);
            color: white;
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 0.8em;
            font-weight: 600;
        }
        
        .version-old {
            background: var(--warning);
        }
        
        .version-new {
            background: var(--success);
        }
        
        .db-test-section {
            background: #fff3cd;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid var(--warning);
        }
        
        .reset-section {
            background: #ffeaea;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid var(--danger);
        }
        
        .action-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .settings-grid {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .header-actions {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .action-buttons {
                width: 100%;
                justify-content: space-between;
            }
            
            .btn-logout, .btn-test, .btn-reset {
                flex: 1;
                text-align: center;
                justify-content: center;
                min-width: 120px;
            }
            
            .header h1 {
                font-size: 2em;
            }
            
            .content {
                padding: 20px;
            }
        }
        
        @media (max-width: 480px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .content {
                padding: 15px;
            }
            
            .btn {
                padding: 15px 20px;
                font-size: 14px;
            }
            
            .header h1 {
                font-size: 1.8em;
                flex-direction: column;
                gap: 10px;
            }
            
            .user-table, .version-table {
                font-size: 14px;
            }
            
            .user-table th, .user-table td,
            .version-table th, .version-table td {
                padding: 8px;
            }
        }
        
        /* Extra small devices */
        @media (max-width: 360px) {
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-logout, .btn-test, .btn-reset {
                width: 100%;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="header-content">
                <h1><i class="fas fa-rocket"></i> NOVA STRIKE MODS</h1>
                <p>Complete Online Control Panel with Version Tracking</p>
            </div>
        </div>
        
        <div class="content">
            <?php if (!isLoggedIn()): ?>
                <!-- Login Form -->
                <div class="login-form" id="loginSection">
                    <div class="login-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    
                    <?php if (isset($error)): ?>
                        <div class="alert alert-error">
                            <i class="fas fa-exclamation-circle"></i>
                            <?php echo htmlspecialchars($error); ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="form-group">
                            <label for="username"><i class="fas fa-user"></i> Username:</label>
                            <input type="text" id="username" name="username" class="form-control" required 
                                   value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="password"><i class="fas fa-key"></i> Password:</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                        </div>
                        
                        <button type="submit" name="login" class="btn btn-primary" style="width: 100%;">
                            <i class="fas fa-sign-in-alt"></i> Login to Dashboard
                        </button>
                    </form>
                    
                    <div class="credential-hint">
                        <p><strong> THIS WEB MAKE BY ONE AND ONLY</strong></strong></strong> DEEPAK</p>
                    </div>
                </div>
                
            <?php else: ?>
                <!-- Dashboard -->
                <?php
                $stats = getStatistics();
                $settings = getCurrentSettings();
                ?>
                <div class="dashboard" id="dashboardSection">
                    <div class="header-actions">
                        <div>
                            <h2><i class="fas fa-tachometer-alt"></i> Dashboard Overview</h2>
                            <p class="welcome-message">Welcome back, <span>Admin</span>! Real-time Version Tracking Active</p>
                        </div>
                        <div class="action-buttons">
                            <form method="POST" style="display: inline;">
                                <button type="submit" name="test_db" class="btn btn-test">
                                    <i class="fas fa-database"></i> Test DB
                                </button>
                            </form>
                            <form method="POST" style="display: inline;">
                                <button type="submit" name="reset_users" class="btn btn-reset" 
                                        onclick="return confirm('⚠️ WARNING: This will DELETE ALL users data! Are you sure?')">
                                    <i class="fas fa-trash-alt"></i> Reset Users
                                </button>
                            </form>
                            <a href="?logout=1" class="btn btn-logout">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                    
                    <?php if (isset($db_test_result)): ?>
                        <div class="db-test-section">
                            <strong>Database Test Result:</strong> <?php echo htmlspecialchars($db_test_result); ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($success)): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i>
                            <?php echo htmlspecialchars($success); ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($error)): ?>
                        <div class="alert alert-error">
                            <i class="fas fa-exclamation-circle"></i>
                            <?php echo htmlspecialchars($error); ?>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Reset Users Warning Section -->
                    <div class="reset-section">
                        <h4><i class="fas fa-exclamation-triangle"></i> Reset All Users</h4>
                        <p>This will permanently delete all users data and reset all statistics to zero. Use with caution!</p>
                    </div>
                    
                    <!-- Statistics -->
                    <div class="stats-grid">
                        <div class="stat-card total-users">
                            <i class="fas fa-users"></i>
                            <h3><?php echo number_format($stats['total_users']); ?></h3>
                            <p>Total Users</p>
                        </div>
                        <div class="stat-card active-users">
                            <i class="fas fa-user-clock"></i>
                            <h3><?php echo number_format($stats['active_users']); ?></h3>
                            <p>Active Users (24h)</p>
                        </div>
                        <div class="stat-card new-today">
                            <i class="fas fa-user-plus"></i>
                            <h3><?php echo number_format($stats['new_today']); ?></h3>
                            <p>New Today</p>
                        </div>
                        <div class="stat-card new-week">
                            <i class="fas fa-chart-line"></i>
                            <h3><?php echo number_format($stats['new_week']); ?></h3>
                            <p>New This Week</p>
                        </div>
                        <div class="stat-card total-requests">
                            <i class="fas fa-exchange-alt"></i>
                            <h3><?php echo number_format($stats['total_requests']); ?></h3>
                            <p>Total Requests</p>
                        </div>
                    </div>
                    
                    <!-- Settings Form -->
                    <div class="settings-form">
                        <h3><i class="fas fa-cogs"></i> Complete Online Control</h3>
                        <form method="POST">
                            <div class="settings-grid">
                                <div class="settings-section">
                                    <h4><i class="fas fa-ban"></i> Expiry Settings</h4>
                                    <div class="form-group">
                                        <label for="expiry_date">Expiry Date:</label>
                                        <input type="date" id="expiry_date" name="expiry_date" 
                                               class="form-control" 
                                               value="<?php echo htmlspecialchars($settings['expiry_date']); ?>" 
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="custom_message">Custom Message:</label>
                                        <textarea id="custom_message" name="custom_message" 
                                                  class="form-control" 
                                                  rows="3" 
                                                  placeholder="Message when app expires"><?php echo htmlspecialchars($settings['custom_message']); ?></textarea>
                                        <small style="color:#666;font-size:11px;">Use \n for new lines</small>
                                    </div>
                                </div>
                                
                                <div class="settings-section">
                                    <h4><i class="fas fa-code-branch"></i> Version Control</h4>
                                    <div class="form-group">
                                        <label for="latest_version">Latest Version:</label>
                                        <input type="text" id="latest_version" name="latest_version" 
                                               class="form-control" 
                                               value="<?php echo htmlspecialchars($settings['latest_version']); ?>" 
                                               placeholder="e.g., 1.2.0" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="update_url">Update URL:</label>
                                        <input type="url" id="update_url" name="update_url" 
                                               class="form-control" 
                                               value="<?php echo htmlspecialchars($settings['update_url']); ?>" 
                                               placeholder="Download link" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="changelog">Changelog:</label>
                                        <textarea id="changelog" name="changelog" 
                                                  class="form-control" 
                                                  rows="3" 
                                                  placeholder="What's new"><?php echo htmlspecialchars($settings['changelog']); ?></textarea>
                                        <small style="color:#666;font-size:11px;">Use \n for new lines</small>
                                    </div>
                                    <div class="checkbox-group">
                                        <input type="checkbox" id="force_update" name="force_update" value="yes" 
                                               <?php echo ($settings['force_update'] ?? 'no') == 'yes' ? 'checked' : ''; ?>>
                                        <label for="force_update">Force update if version doesn't match</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="settings-section" style="margin-top:15px;">
                                <h4><i class="fab fa-telegram"></i> Telegram & Links</h4>
                                <div class="form-group">
                                    <label for="telegram_url">Telegram Channel URL:</label>
                                    <input type="url" id="telegram_url" name="telegram_url" 
                                           class="form-control" 
                                           value="<?php echo htmlspecialchars($settings['telegram_url']); ?>" 
                                           placeholder="https://t.me/yourchannel" required>
                                </div>
                            </div>
                            
                            <button type="submit" name="update_settings" class="btn btn-primary" style="margin-top:15px;">
                                <i class="fas fa-save"></i> Save All Settings
                            </button>
                        </form>
                    </div>
                    
                    <!-- Version Statistics -->
                    <?php if (!empty($stats['version_stats'])): ?>
                    <div class="version-stats">
                        <h3><i class="fas fa-chart-bar"></i> Version-Wise User Distribution</h3>
                        <table class="version-table">
                            <thead>
                                <tr>
                                    <th>App Version</th>
                                    <th>Total Users</th>
                                    <th>Percentage</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $totalUsers = $stats['total_users'];
                                $latestVersion = $settings['latest_version'];
                                foreach ($stats['version_stats'] as $version): 
                                    $isLatest = $version['app_version'] == $latestVersion;
                                    $percentage = $totalUsers > 0 ? round(($version['total_users'] / $totalUsers) * 100, 1) : 0;
                                ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($version['app_version'] ?: 'Unknown'); ?></strong>
                                        <?php if ($isLatest): ?>
                                            <span class="version-badge version-new">LATEST</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo number_format($version['total_users']); ?></td>
                                    <td>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <div style="flex: 1; background: #e9ecef; border-radius: 4px; height: 8px;">
                                                <div style="background: var(--primary); width: <?php echo $percentage; ?>%; height: 100%; border-radius: 4px;"></div>
                                            </div>
                                            <span style="font-weight: 600; color: var(--primary);"><?php echo $percentage; ?>%</span>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($isLatest): ?>
                                            <span style="color: var(--success); font-weight: 600;">ACTIVE</span>
                                        <?php else: ?>
                                            <span style="color: var(--warning); font-weight: 600;">LEGACY</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="version-stats">
                        <h3><i class="fas fa-chart-bar"></i> Version-Wise User Distribution</h3>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            No version statistics available yet. Users will appear here after they connect to the app.
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Recent Users -->
                    <div class="recent-users">
                        <h3><i class="fas fa-users"></i> Recent Active Users</h3>
                        <?php if (!empty($stats['recent_users'])): ?>
                        <table class="user-table">
                            <thead>
                                <tr>
                                    <th>User ID</th>
                                    <th>Device ID</th>
                                    <th>Version</th>
                                    <th>First Seen</th>
                                    <th>Last Seen</th>
                                    <th>Requests</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($stats['recent_users'] as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['user_id']); ?></td>
                                    <td><span class="info-badge"><?php echo htmlspecialchars(substr($user['device_id'] ?? 'Unknown', 0, 8)); ?></span></td>
                                    <td>
                                        <span class="version-badge <?php echo ($user['app_version'] == $latestVersion) ? 'version-new' : 'version-old'; ?>">
                                            <?php echo htmlspecialchars($user['app_version'] ?: 'Unknown'); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M j, g:i A', strtotime($user['first_seen'])); ?></td>
                                    <td><?php echo date('M j, g:i A', strtotime($user['last_seen'])); ?></td>
                                    <td><?php echo number_format($user['request_count']); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            No recent users found. Users will appear here after they connect to the app.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <script>
                    // Auto refresh every 30 seconds
                    setTimeout(function() {
                        window.location.reload();
                    }, 30000);
                </script>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
